;--------------------------------------------------------------------------------
;-- update_tab4_v2.asm
;--
;-- This file contains the routine for updating the loco address and its "age" 
;-- in tab4.
;-- tab4 starts at SRAMTab4 and holds 8 (16/32) bytes for the loco-adr and
;--                                   8 (16/32) bytes for the loco-adr age
;--
;--------------------------------------------------------------------------------

UpdateTab4:  
            rcall Mul16Tab3
            clr   Tmp2                 ; Tmp2 is used as counter in this routine

            ldd   Tmp1,Z+7             ; load Tab3 Data7
            sbrc  Tmp1,6               ; is Tab3 Data7 Bit6 already set (loco adr is in tab4)?
            rjmp  LocoAdrInTab4        ; yes, LocoAddress is in Tab4
            
;--------------------------------------------------------------------------------
; Loco address is not set so far in Tab4
; search linear for the highest loco address age
; increment a counter each time a new loco address age was loaded from Tab4
; if the highest age was found, set this age to 0
; read out from Tab4 the loco address which did have the highest age
; replace it with the actual loco address
; increment all loco address ages
; clear the B bit in Tab3 Data7 Bit6 for the replaced loco-address

            ori   Tmp1,0b01000000      ; set Tab3 Data7 Bit6 
            std   Z+7,Tmp1             ; and write it back to Tab3 Data7

            ldi   YL,low(SRAMTab4+32)
            ldi   YH,high(SRAMTab4+32)

            ldi   Tmp1,Tab4Length
Loop3:      inc   Tmp2
            ld    Tmp3,Y+              ; load first age from Tab4
            cpse  Tmp3,Tmp1            ; is this the highest age?
            rjmp  Loop3                ; no

            clr   Tmp1
            st    -Y,Tmp1              ; set age to 0

            dec   Tmp2                 ; counter is 1 to high due to the increment in the beginning

            ldi   YL,low(SRAMTab4)     ; set Y-Pointer now to the addresses
            ldi   YH,high(SRAMTab4)

            add   YL,Tmp2              ; add counter to the start value
            sbci  YH,high(-0x0000)

            ld    Tmp3,Y               ; this is the old loco address
            st    Y,LocoAdrLow         ; set new loco address

            ldi   YL,low(SRAMTab4+32)  ; set Y-Pointer now to the age of the addresses
            ldi   YH,high(SRAMTab4+32)

            clr   Tmp2
Loop4:      inc   Tmp2
            ld    Tmp1,Y               ; load first age from Tab4
            inc   Tmp1                 ; increment age
            st    Y+,Tmp1              ; and store it back to Tab4
            cpi   Tmp2,Tab4Length      ; end Loop2 and Update of Tab4
            brlo  Loop4
 
            ; mutiply the loco address with 16 and add the offset for the table 3
            ; result is stored in Z-register

            mov   ZL,Tmp3
            clr   ZH

            lsl   ZL                    ; mult 2
            rol   ZH         
            lsl   ZL                    ; mult 4
            rol   ZH         
            lsl   ZL                    ; mult 8
            rol   ZH         
            lsl   ZL                    ; mult 16
            rol   ZH         

            subi  ZL,low(-SRAMTab3)     ; add offset for table 3 to result
            sbci  ZH,high(-SRAMTab3)

            ldd   Tmp1,Z+7              ; load Tab3 Data7
            andi  Tmp1,0b10111111       ; clear Tab3 Data7 Bit6
            std   Z+7,Tmp1

            ret

;--------------------------------------------------------------------------------
; Loco address is already set in Tab4
; search linear for actual loco adr in Tab4
; increment a counter each time a new address was loaded from Tab4
; if the address was found, than switch over to age of the addresses
; store the actual age of the loco address
; set the age to 0 for the actual loco address. Position is known
; because of the counter.
; start incrementing each loco-address age which is lower than the stored
; actual loco age

LocoAdrInTab4:

            ldi   YL,low(SRAMTab4)
            ldi   YH,high(SRAMTab4)

Loop1:      inc   Tmp2
            ld    Tmp3,Y+              ; load first address from Tab4
            cpse  Tmp3,LocoAdrLow      ; did the loco adr match?
            rjmp  Loop1                ; no

            dec   Tmp2                 ; counter is 1 to high due to the increment in the beginning

            ldi   YL,low(SRAMTab4+32)  ; set Y-Pointer now to the age of the addresses
            ldi   YH,high(SRAMTab4+32)

            add   YL,Tmp2              ; add counter to the start value
            sbci  YH,high(-0x0000)

            ld    Tmp3,Y               ; this is the old age of the actual loco address
            clr   Tmp2
            st    Y,Tmp2               ; set age back to 0

            ldi   YL,low(SRAMTab4+32)  ; set Y-Pointer now to the age of the addresses
            ldi   YH,high(SRAMTab4+32)

Loop2:      inc   Tmp2
            ld    Tmp1,Y+              ; load first age from Tab4
            cp    Tmp1,Tmp3            ; compare loaded age with last age of actual loco address
            brlo  IncAge        
Loop2Cont:  cpi   Tmp2,Tab4Length      ; end Loop2 and Update of Tab4
            brlo  Loop2
            ret

IncAge:     inc   Tmp1
            st    -Y,Tmp1              ; store byck incremented age
            ld    Tmp1,Y+              ; dummy read to increment the Y-Pointer
            rjmp  Loop2Cont

;--------------------------------------------------------------------------------