;--------------------------------------------------------------------------------
;-- update_tab3_v2.asm
;--
;-- This file contains the routine for updating new loco information written to
;-- tab3 in tab2.
;-- tab2:  32 device dependent loco pattern 
;-- tab3: 255 loco   dependent loco information 
;--
;--------------------------------------------------------------------------------

UpdateTab3: ; 
            ; let Y-pointer point to Tab3 Data0 for the actual loco-address, Z-Pointer is used for lpm-cmd
            ; To avoid errors due to the update time here and in the interrupt routine, set a
            ; flag first for the device in Tab3 Data15 Bit7 to indicate that an update event currently takes place
            ; This flag is evaluated in the interrupt-routine, which stores a new sequence to the pattern
            ; generation process
            ; The flag is cleared when all info is updated.
            
;-- update Tab3 Data15 and set the update lock bit

            mov   YL,ZL
            mov   YH,ZH

            ldi   Tmp3,0b10000000      ; set Tab3 Data7 Bit7 (update lock bit)
            ldd   Tmp2,Y+7             ; load Tab3 Data7 Bit7
            sbrc  Tmp2,7
            ori   Tmp3,0b00000010      ; yes direction has changed (load preload value [2] for pattern multiply)
            ldd   Tmp1,Y+1             ; load Tab3 Data1 (Dir and Speed)
            ori   Tmp3,0b00010000      ; if direction will be forward, than set Bit 4
            sbrs  Tmp1,7               ; is Tab3 Data1 Bit7 (R) bit set (if set, than FORWARD!)
            andi  Tmp3,0b11101111      ; because R Bit is not set, clear bit 4 again
            std   Y+15,Tmp3            ; now updating is locked and Tab3 Data15 is actualized

            ; in the following code, the lpm command is used. Therefore the Z-Pointer is needed. The Z-Pointer
            ; is needed only one more time, which is to load the function status from the SRAM
            ; This is done now to free the Z-Pointer. The function status is stored to Tmp2. Take
            ; care not to overwrite Tmp2.

            ldd   Tmp2,Y+2             ; preload the function status from SRAM now

;-- update Tab3 Data9 (Speed-pattern)

            andi  Tmp1,0x07F           ; clear Tab3 Data0 Bit 7 (only speed info is now stored in Tmp1)
            cpi   Tmp1,0               ; is speed = 0 than continue normally
            breq  Speed0
            dec   Tmp1                 ; because speed is > 0 a 1 has to be subtracted from the speed value (see
                                       ; lenz protocol for speed 1 to 15 which is 0 to 14!)

Speed0:     clr  ZH                    ; loesche das High-Byte vom Z-Register
            ldi  ZL,BASpeedTable       ; lade die Basisadresse des Geschwindigkeitsbereichs in das LowByte des Z-Registers
            	  
            sbrs Tmp3,4                ; frage das Bit 4 ab, hier ist definiert, ob vor- oder rueckwaerts 
                                       ; gefahren wird ('1' = FORWARD)
            rjmp NegSpeed              ; es wird rueckwaerts gefahren          
PosSpeed:   add  ZL,Tmp1               ; addiere jetzt zur Basisadresse den aktuellen Geschwindigkeitswert
            lsl  ZL                    ; verschiebe jetzt noch den Wert um 1 Stelle nach links (wegen lpm-Kommando)
            inc  ZL                    ; addiere noch eine 1, da das obere Byte geladen werden musss
            rjmp LoadSp                ; springe zur Routine, die das Speed-Pattern aus dem SRAM ausliest
	    	  
NegSpeed:   add  ZL,Tmp1               ; addiere jetzt zur Basisadresse den aktuellen Geschwindigkeitswert
            lsl  ZL                    ; verschiebe jetzt noch den Wert um 1 Stelle nach links (wegen lpm-Kommando)
	    	  
LoadSp:     lpm                        ; nun steht das Pattern in r0
            std  Y+9,r0                ; lege nun das Speed-Pattern im SRAM an der Stelle ab, aus der das 
                                       ; Muster immer wieder bei der Signalgenerierung geholt wird

;-- update Tab3 Data8 (address-pattern)

                                       ; hier wird nun aufgrund der in LocoAdrLow stehenden Adresse die
                                       ; Position in der konst. Tabelle fuer die Adress-Signalmuster berechnet
                                       ; Basisadresse ist abgelegt in "BAAddressTable"
                                       ; die Adressen sind wie folgt abgelegt:
                                       ;                      MSB   LSB
                                       ; BAAddressTable +  0: Adr 1,Adr 0
                                       ; BAAddressTable +  1: Adr 3,Adr 2
                                       ; BAAddressTable +  n:     |
                                       ; BAAddressTable + 38: Adr77,Adr76
                                       ; BAAddressTable + 39: Adr79,Adr78
                                       ; 
                                       ; damit muss die Adresse wie folgt berechnet werden:
                                       ; LocoAdrLow nach Z speichern, um den Zustand des untersten Bits nicht zu verlieren
                                       ; dies ist wichtig, um zu erkennen, ob eine gerade oder eine ungerade Adresse
                                       ; behandelt werden muss
                                       ; Z nach rechts schieben (durch 2 teilen)
                                       ; Z zur Basisadresse addieren
                                       ; Ergebnis (Z) 1 mal nach links schieben (wegen lpm-Kommando)
                                       ; wenn nun das unterste Bit in LocoAdrLow gesetzt ist, muss Z inkrementiert werden
                                       ; ansonsten kann direkt das Pattern nach r0 geladen werden
                                       ; dann wird r0 wieder an die Pattern-Signalgenerierungsadresse ins SRAM gespeichert

             

             clr  ZH
             mov  ZL,LocoAdrLow        ; sichere LocoAdrlow
             lsr  ZL
             subi ZL,-BAAddressTable   ; addiere nun den Offset
             lsl  ZL                   ; nun wegen lpm-Kommando 1 mal wieder nach links schieben
             sbrc LocoAdrLow,0         ; ungerade oder gerade Adresse?
             inc  ZL                   ; Bit war gesetzt -> ungerade Adrese, also ZL inkrementieren, um an MSB zu kommen
             lpm  
             std  Y+8,r0               ; lege nun das Adress-Pattern im SRAM zur Signalgenerierung ab

;--  update Tab3 Data10,11,12,13 and 14 (function and special function-pattern)

             clr  ZH                   ; loesche das Z-Register High-Byte
             lsl  Tmp1                 ; multipliziere Speed mit 2 
             ldi  ZL,BAFTable          ; lade Z-Register Low-Byte mit Basisadresse fuer die Funktions-Tabelle
             add  ZL,Tmp1              ; addiere die Geschwindigkeit zur Basisadresse
             lsr  Tmp1                 ; hole alten Wert von Tmp1 wieder

             lsl  ZL                   ; verschiebe jetzt noch den Wert um 1 Stelle nach links (wegen lpm-Kommando)
             lpm                       ; lade jetzt F1 in R0
             sbrc Tmp2,0               ; ueberpruefe, ob Funktionstaste aktiv ist                  
             rjmp F1On	  
DoF1:        std  Y+10,r0              ; lege das Pattern fuer F1 wieder im SRAM fuer die Signalgenerierung ab
             inc  ZL	
             lpm                       ; lade jetzt F2
             sbrc Tmp2,1               ; ueberpruefe, ob Funktionstaste aktiv ist                  
             rjmp F2On                 ;
DoF2:        std  Y+11,r0              ; lege das Pattern fuer F2 wieder im SRAM fuer die Signalgenerierung ab
             inc  ZL	
             lpm                       ; lade jetzt F3
             sbrc Tmp2,2               ; ueberpruefe, ob Funktionstaste aktiv ist                  
             rjmp F3On                 ;
DoF3:        std  Y+12,r0              ; lege das Pattern fuer F3 wieder im SRAM fuer die Signalgenerierung ab
             inc  ZL	
             lpm                       ; lade jetzt F4
             sbrc Tmp2,3               ; ueberpruefe, ob Funktionstaste aktiv ist                  
             rjmp F4On                 ;
DoF4:        std  Y+13,r0              ; lege das Pattern fuer F4 wieder im SRAM fuer die Signalgenerierung ab

;-- update Tab3 Data14 (SF-pattern)

             ldi  Tmp1,$C0             ; Speedinfo is not used any longer, so prepare for setting the SF-Pattern
             sbrs Tmp2,4               ; is Tab3 Data2 Bit4 (SF Bit) set?
             clr  Tmp1                 ; no, clear SF-Pattern now
             std  Y+14,Tmp1            ; store SF-Pattern back to Tab3 Data14

;-- all info are stored now for the actual device in Tab3
;-- release now the lock for updating

             ldd   Tmp1,Y+15           ; load Tab3 Data7
             andi  Tmp1,0x7F           ; clear Tab3 Data7 Bit7
             std   Y+15,Tmp1           ; now updating is released
             ret            
    
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
    
F1On:        cpi  Tmp1,2               ; vergleiche Speed mit 2, dann muss ein Sonderpattern gespeichert werden
             breq F1On_2               ; 
             cpi  Tmp1,10              ; vergleiche Speed mit 10, dann muss ein Sonderpattern gespeichert werden
             breq F1On_10              ; 
             inc  r0                   ; wenn ja ergaenze Pattern OFF zu Pattern ON
             rjmp DoF1            	       
     
F1On_2:      ldi Tmp4,PF1_2            ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF1                 ; und springe zum Speichern des Patterns wieder zurueck             
     
F1On_10:     ldi Tmp4,PF1_10           ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF1                 ; und springe zum Speichern des Patterns wieder zurueck             
;----------------------------------
F2On:        cpi  Tmp1,3               ; vergleiche Speed mit 3, dann muss ein Sonderpattern gespeichert werden
             breq F2On_3               ; 
             cpi  Tmp1,11              ; vergleiche Speed mit 11, dann muss ein Sonderpattern gespeichert werden
             breq F2On_11              ; 
             inc  r0                   ; wenn ja ergaenze Pattern OFF zu Pattern ON
             rjmp DoF2            	       
     
F2On_3:      ldi Tmp4,PF2_3            ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF2                 ; und springe zum Speichern des Patterns wieder zurueck             
     
F2On_11:     ldi Tmp4,PF2_11           ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF2                 ; und springe zum Speichern des Patterns wieder zurueck             
;----------------------------------
F3On:        cpi  Tmp1,5               ; vergleiche Speed mit 5, dann muss ein Sonderpattern gespeichert werden
             breq F3On_5               ; 
             cpi  Tmp1,13              ; vergleiche Speed mit 13, dann muss ein Sonderpattern gespeichert werden
             breq F3On_13              ; 
             inc  r0                   ; wenn ja ergaenze Pattern OFF zu Pattern ON
             rjmp DoF3            	       
     
F3On_5:      ldi Tmp4,PF3_5            ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF3                 ; und springe zum Speichern des Patterns wieder zurueck             
     
F3On_13:     ldi Tmp4,PF3_13           ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF3                 ; und springe zum Speichern des Patterns wieder zurueck             
;----------------------------------
F4On:        cpi  Tmp1,6               ; vergleiche Speed mit 6, dann muss ein Sonderpattern gespeichert werden
             breq F4On_6               ; 
             cpi  Tmp1,14              ; vergleiche Speed mit 14, dann muss ein Sonderpattern gespeichert werden
             breq F4On_14              ; 
             inc  r0                   ; wenn ja ergaenze Pattern OFF zu Pattern ON
             rjmp DoF4            	       
     
F4On_6:      ldi Tmp4,PF4_6            ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF4                 ; und springe zum Speichern des Patterns wieder zurueck             
     
F4On_14:     ldi Tmp4,PF4_14           ; lade Tmp4 mit dem Sonderpattern
             mov r0,Tmp4               ; speichere es in r0
             rjmp DoF4                 ; und springe zum Speichern des Patterns wieder zurueck             
;----------------------------------
