;-------------------------------------------------------------------------------------------------------
;-- datagen_t1_compb.asm
;--
;-- In der folgenden (Interrupt)-Routine werden die korekten Zeiten fuer das Bitmuster zum Booster
;-- generiert. Ausserdem wird in der Pause T3 bestimmt, von welchem Fahrpult welche Information als
;-- naechstes zu senden ist. Diese Informationen werden beim ersten Aufruf nach der Pause T3 aus Tab2
;-- im SRAM ausgelesen.
;-------------------------------------------------------------------------------------------------------

;-------------------------------------------------------------------------------------------------------
;-- DCC-Version SEG 
;-------------------------------------------------------------------------------------------------------


TIM1_COMPB: 

              PUSHTmp;
              
;-------------------------------------------------------------------------------------------------------
;-- hole aktuelle Timerwerte, werden am Ende neu gesetzt 
;-------------------------------------------------------------------------------------------------------

              in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH

;-------------------------------------------------------------------------------------------------------
;-- stelle fest, ob erste oder zweite Haelfte des Bits uebertragen werden muss
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- Prambel ??
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- Neues Byte // XOR ???
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- nchstes Bit
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- Bit Laden !!!
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- Timerwerte setzen
;-------------------------------------------------------------------------------------------------------
              


;-------------------------------------------------------------------------------------------------------
;-- 
;-------------------------------------------------------------------------------------------------------
              








;-------------------------------------------------------------------------------------------------------
;-- 1. Haelfte des Bits wird behandelt (Ausgang ist immer '1')
;-- stelle fest, ob schon alle 18 Bits versendet worden sind, wenn ja gehe zur Pausenroutine
;-------------------------------------------------------------------------------------------------------

              ldi   Tmp1,MaxBits
              cp    BitCnt,Tmp1                
              breq  PrepPause

              inc   BitHalf
              inc   BitCnt

              sbrc  HighByte,7
              rjmp  PrepLong1st
              rcall PrepShort
              POPTmp;
              reti

PrepLong1st:  rcall PrepLong
              POPTmp;
              reti

;-------------------------------------------------------------------------------------------------------
;-- 2. Haelfte des Bits wird behandelt (Ausgang ist immer '0')
;-------------------------------------------------------------------------------------------------------

SecondPart:   clr   BitHalf              ; loesche BitHalf wieder, 1. Haelfte ist wieder dran
 
              ldi   Tmp1,MaxBits
              cp    BitCnt,Tmp1          ; wenn das MaxBits. Bit gesendet wurde, dann wird einmal
              breq  NoToggle             ; beim Int der Ausgang fuer die Pause auf '0' gehalten

Cont2nd:      sbrc  HighByte,7           ; ist das oberste Bit eine '1' oder '0'
              rjmp  PrepShort2nd
              rcall PrepLong
ShiftLeft:    clc                        ; loesche das Carry-Bit wegen der folgenden Schiebeoperationen
              sbrc  HighByte,7           ; ist das oberste Bit im HighByte eine '1'?
              sec                        ; ja, dann setze das Carry-Bit wieder
              rol   LowByte              ; hier werden alle Register nach links geschoben
              rol   MiddleByte           ; dabei wird jedesmal das Carry-Bit in R(0) des
              rol   HighByte             ; hoeheren Registers geschoben HighByte <- C <- MiddleByte <- C <- LowByte <- C
              POPTmp;
              reti                       ;

PrepShort2nd: rcall PrepShort
              rjmp  ShiftLeft

NoToggle:     ldi   Tmp1,0b00110000     ; wenn die 2te Haelfte des letzten Bits eines Packets versendet
              ;ldi   Tmp1,0b00100000      ; ### this is for inverting the output signal
              out   TCCR1A,Tmp1          ; wird, dann folgt eine Pause und die Ausgabe bleibt '1'
              rjmp  Cont2nd              ; also wird das Toggeln ausgestellt, wenn der naechste Int auftritt

;-------------------------------------------------------------------------------------------------------
;-- Bereite die Pausen vor
;-------------------------------------------------------------------------------------------------------

PrepPause:    clr   BitCnt               ; loesche den Bitzaehler

              ldi   Tmp1,0b00010000      ; wenn die Pause wieder zu Ende ist, dann Toggle wieder
              out   TCCR1A,Tmp1          ; da waehrend der Pause eine '1' anliegt, kommt nach der 
                                         ; Pause wieder eine '0'
              ldi   Tmp1,3
              cp    NrPause,Tmp1
              breq  PrepT3

              ldi   Tmp1,1
              cp    NrPause,Tmp1
              breq  PrepT2

PrepT1:       inc   NrPause

              in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH
              subi  Tmp1,low(-T1)
              sbci  Tmp2,high(-T1)
  
              out   OCR1BH,Tmp2          ; lade das Vergleichsregister fuer A mit T1 = 1.64 ms
              out   OCR1BL,Tmp1
              
              rjmp  PatternRol           ; verschiebe jetzt das Pattern nach links.

PrepT2:       inc   NrPause
              
              in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH
              subi  Tmp1,low(-T2)
              sbci  Tmp2,high(-T2)  

              out   OCR1BH,Tmp2          ; lade das Vergleichsregister fuer A mit T1 = 4.24 ms
              out   OCR1BL,Tmp1

PatternRol:   clc                        ; loesche das Carry-Bit wegen der folgenden Schiebeoperationen
              sbrc  HighByte,7           ; ist das oberste Bit im HighByte eine '1'?
              sec                        ; ja, dann setze das Carry-Bit wieder

              ldi   Tmp1,6               ; lade Schleifenzaehler
LoopRol:      cpi   Tmp1,0               ; stehen alle Bits wieder an ihrem Ausgangspunkt? 
              breq  LoopEnd              ; wenn ja, dann beende Loop 

              rol   LowByte              ; hier werden alle Register nach links geschoben
              rol   MiddleByte           ; dabei wird jedesmal das Carry-Bit in R(0) des
              rol   HighByte             ; hoeheren Registers geschoben HighByte <- C <- MiddleByte <- C <- LowByte <- C
              dec   Tmp1
              rjmp  LoopRol              ; springe wieder in die Schleife

LoopEnd:      POPTmp;
              reti                       ;

PrepT3:       clr   NrPause              ; hier gibt es ein Flussdiagramm (Pause3.fig)
 
              in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH
              subi  Tmp1,low(-T3)
              sbci  Tmp2,high(-T3)  

              out   OCR1BH,Tmp2          ; lade das Vergleichsregister fuer A mit T1 = 6.1 ms
              out   OCR1BL,Tmp1

              ldi   Tmp1,LocoAdrMax      ; ab hier wird entschieden, welches Fahrpult im naechsten
              cp    LocoAdrPointer,Tmp1  ; Durchlauf, mit welcher Geschwindigkeit oder welcher
              brne  A                    ; Sequenz abgearbeitet werden soll
              ldi   Tmp1,SeqMax
              cp    SeqPointer,Tmp1
              brne  B
              sbrs  SpPointer,0
              rjmp  C

D:            clr   LocoAdrPointer
              clr   SeqPointer
              clr   SpPointer
              rjmp  NewSeq

C:            inc   SpPointer
              rjmp  NewSeq

B:            sbrs  SpPointer,0
              rjmp  C
E:            clr   LocoAdrPointer
              inc   SeqPointer
              clr   SpPointer 
              rjmp  NewSeq

A:            ldi   Tmp1,SeqMax
              cp    SeqPointer,Tmp1
              brne  F
              sbrs  SpPointer,0
              rjmp  C
G:            inc   LocoAdrPointer
              clr   SPPointer
              rjmp  NewSeq

F:            sbrs  SpPointer,0
              rjmp  C
              inc   LocoAdrPointer
              clr   SpPointer
              rjmp  NewSeq               ; regeneriere das Pattern

;-------------------------------------------------------------------------------------------------------
;-- im folgendem Ablauf werden jetzt aus Tab3 im SRAM die drei Bytes fuer die naechste Sequenz geholt
;-- Dazu gibt es ein Flussdiagramm (Start.fig)
;-------------------------------------------------------------------------------------------------------
                                          ; SRAMTab4 + LocoAdrPointer * 8 := Next Loco Address 
NewSeq:       
              push  ZH                    ; do not modify this pointer, because it is needed in the main routines
              push  ZL                    ; so, store it on the stack

              clr   ZH
              mov   ZL,LocoAdrPointer     ; save the LocoAdrPointer to Z
              subi  ZL,low(-SRAMTab4)     ; add offset for table 4 to result
              sbci  ZH,high(-SRAMTab4)    ; 

              ld    Tmp1,Z                ; load loco-adr from actual pointer position from SRAM
              mov   ZL,Tmp1               ; calculate now the location of data for the new loco address in Tab3
              clr   ZH                    ; SRAMTab3 + LocoAddress * 16 := position of data in Tab3 for selected loco

              lsl   ZL                    ; mult 2
              rol   ZH         
              lsl   ZL                    ; mult 4
              rol   ZH         
              lsl   ZL                    ; mult 8
              rol   ZH         
              lsl   ZL                    ; mult 16
              rol   ZH         

              subi  ZL,low(-SRAMTab3)     ; add offset for table 3 to result
              sbci  ZH,high(-SRAMTab3)

;-- ask now if an update is still in progress. Therefore read Tab3 Data15 Bit7

              ldd   Tmp1,Z+15
              sbrs  Tmp1,7
              rjmp  UpdateNormal 

              ;because an update for this device is just in progress, fill in the idle-pattern

              ldi   HighByte,Idle        ; Idle-Pattern
              clr   MiddleByte           ; Idle-Pattern
              clr   LowByte              ; Idle-Pattern
              clr   Tmp1                 ; 
              rjmp  Rotate 

UpdateNormal: ldd   HighByte,Z+8         ; load Address-Pattern from SRAM
              
;-------------------------------------------------------------------------------------------------------
;-- frage nun ab, ob weiterhin das Pattern zur Richtungsaenderung gesendet werden muss:
;-------------------------------------------------------------------------------------------------------
              
              ldd   DirChange,Z+15       ; load value from SRAM in DirChange
              ldi   Tmp1,0               ; 
              mov   Tmp2,DirChange       ; save only counter in lower nibble
              andi  Tmp2,0x0F            ; therefore clear upper nibble
              cp    Tmp1,Tmp2            ; is counter = 0 than
              breq  LoadSeq              ; .. cont. normally

              ; wenn nicht, dann muss das Richtungswechsel-Pattern
              ; eingefuegt werden. Dies geschieht solange, bis 
              ; DirChange wieder auf 0 gesetzt wurde. Weil schon bei der
              ; Richtungswechsel-Anforderung die Geschwindigkeit 0 bei
              ; neuer Richtung im SRAM abgelegt wurde, geht es dann mit 
              ; mit dem dort abgelegten Pattern weiter

              ldi   Tmp3,SpeedRF         ; wenn das Bit 0 ist, dann lade Speed r+, ansonsten ...
              sbrs  DirChange,4          ; frage die Richtungsinformation ab ...
              ldi   Tmp3,SpeedRB         ; wenn das Bit 1 ist, dann lade Speed r-
              mov   MiddleByte,Tmp3      ; und lege die Information im Middle-Byte der Pattergenerierung ab 
              dec   DirChange            ; dekrementiere DirChange
              std   Z+15,DirChange       ; and store it back to SRAM
              rjmp  Rotate               ; und fuege als naechstes die SF ein              
                                         
;--------------------------------------------------------------------------------------------------
                                         
LoadSeq:      sbrs  SpPointer,0          ; wenn das 0te Bit im SpPointer gesetzt ist, dann lade die Funktion
              rjmp  LoadSpeed            ; sonst die Geschwindigkeit
                                         
LoadFunc:                                
              ldd   Tmp1,Z+14            ; load SF in a temp register to modify now the Z-pointer
              adiw  ZL,10                ; SRAMTab3 + 10 + LocoAddr * 16

              clr   Tmp2
              add   ZL,SeqPointer        ; add SeqPointer (0,1,2 or 3) 
              adc   ZH,Tmp2
              ld    MiddleByte,Z         
              rjmp  Rotate               
                                         
LoadSpeed:    ldd   MiddleByte,Z+9       ; SRAMTab2 + 1 + LocoAdrPointer * 7   
              ldd   Tmp1,Z+14            ; load SF in a temp. register
                                         
Rotate:       clr   LowByte              ; muss nicht unbedingt sein, ist aber sicherer
              clc                        ; loesche das Carry-Bit
              ror   MiddleByte           ; verschiebe jetzt das mittlere und unterste Byte um
              ror   LowByte              ; 2 Positionen nach rechts, damit gleich die SF in das
              ror   MiddleByte           ; mittlere Byte hineingeodert werden kann
              ror   LowByte

              or    MiddleByte,Tmp1      ; verodere jetzt das temp. Register mit dem mittleren Byte
                                         ; jetzt steht in allen drei Bytes die neue 18 Bit-Sequenz

              pop   ZL                   ; reload Z-Pointer from the stack
              pop   ZH                   
              POPTmp;
              reti
              
;-------------------------------------------------------------------------------------------------------
;-- Aktualisiere das Vergleichsregister fuer eine kurze oder lange Impulsdauer
;-------------------------------------------------------------------------------------------------------

PrepShort:    in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH
              subi  Tmp1,low(-Short)
              sbci  Tmp2,high(-Short)

              out   OCR1BH,Tmp2         ; lade das Vergleichsregister fuer A mit 1x26 us
              out   OCR1BL,Tmp1
              ret 

PrepLong:     in    Tmp1,OCR1BL
              in    Tmp2,OCR1BH
              subi  Tmp1,low(-Long)
              sbci  Tmp2,high(-Long)






              out   OCR1BH,Tmp2         ; lade das Vergleichsregister fuer A mit 7x26 us
              out   OCR1BL,Tmp1
              ret

;-------------------------------------------------------------------------------------------------------
